/**
* Script: equipbox.js
* Written by: Radnen
* Updated: 1/14/2011
**/

function EquipmentBox(parent, x, y, w, h, sw, sh)
{
	this.inherit = Control;
	this.inherit(parent, x, y, w, h);
	
	this.slot_w = sw;
	this.slot_h = sh;
	this.useWindow = false;
	this.slots = [];
	this.slot = null;
	
	this.addSlot = function(x, y, type) {
		this.slots.push({x: x, y: y, type: type, item: null});
	}
	
	this.equipSlot = function(item) {
		if (!item) return;
		var slot = Utility.findIn(this.slots, item.type, "type");
		slot.item = item;
		Genesis.player.equipment[item.type] = item.name;
	}
	
	this.unequipSlot = function(type) {
		var slot = Utility.findIn(this.slots, type, "type");
		var name = null;
		if (slot.item) name = slot.item.name;
		slot.item = null;
		Game.player.equipment[type] = null;
		return name;
	}
	
	this.onItemDoubleClick = function(){};
	
	this.setEquipment = function() {
		Utility.foreach(this.slots, function(slot) {
			//slot.item = Items[Genesis.player.equipment[slot.type]];
		});
	}
	
	this.draw = function() {
		this.x = this.parent.x + this.xx;
		this.y = this.parent.y + this.yy;
		if (this.useWindow) System.menuWindow.drawWindow(this.x, this.y, this.w, this.h);
		
		var slot_x = 0;
		var slot_y = 0;
		Utility.foreach(this.slots, function(slot, sender) {
			var x = sender.x+slot.x;
			var y = sender.y+slot.y;
			System.basicWindow.drawWindow(x, y, sender.slot_w, sender.slot_h);
			
			if (slot.item !== null) slot.item.image.blit(x, y);

			if (Cursor.isWithin(x, y, sender.slot_w, sender.slot_h) && sender.entered) {
				sender.slot = slot;
				slot_x = x;
				slot_y = y;
				if (Cursor.onLeftDoubleClick()) sender.onItemDoubleClick();
			}
		}, this);
		
		if (this.slot) {
			var text = this.slot.type;
			if (this.slot.item != null) text = this.slot.item.name;
			var w = System.textFont.getStringWidth(text);
			System.basicWindow.drawWindow(slot_x+8-w/2, slot_y-16, w, System.textFont.getHeight());
			System.textFont.drawText(slot_x+8-w/2, slot_y-16, text);
		}
	}
}